<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\AuthCodeResource;
use App\Models\AuthCode;
use Illuminate\Http\Request;

class AuthCodeController extends Controller
{
    public function __construct()
    {
        // Protect all methods in this controller with the AuthCodePolicy.
        $this->authorizeResource(AuthCode::class, 'auth_code');
    }

    /**
     * Display a listing of the resource.
     * Allows filtering by user_id for admins.
     */
    public function index(Request $request)
    {
        $validated = $request->validate([
            'user_id' => 'required|exists:users,id',
        ]);

        $authCodes = AuthCode::where('user_id', $validated['user_id'])
                             ->latest()
                             ->get();

        return AuthCodeResource::collection($authCodes);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AuthCode $authCode)
    {
        $authCode->delete();
        return response()->json(null, 204);
    }
}
