<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use App\Models\Admin;

class DashboardController extends Controller
{
    /**
     * Show the main dashboard status page.
     */
    public function index()
    {
        try {
            DB::connection()->getPdo();
            $dbStatus = 'Connected successfully to database: ' . DB::connection()->getDatabaseName();
            $dbStatusClass = 'text-green-600';
        } catch (\Exception $e) {
            $dbStatus = 'Could not connect to the database. Please check your configuration. Error: ' . $e->getMessage();
            $dbStatusClass = 'text-red-600';
        }

        $totalClients = User::count();
        $totalAdmins = Admin::count();

        return view('dashboard.index', compact('dbStatus', 'dbStatusClass', 'totalClients', 'totalAdmins'));
    }

    /**
     * Show the API request logs.
     */
    public function apiLogs(Request $request)
    {
        $logPath = storage_path('logs/laravel.log');
        $logs = [];
        $filterLevel = $request->query('level'); // Get filter level from query parameter

        if (File::exists($logPath)) {
            $fileContent = File::get($logPath);
            $lines = explode("\n", $fileContent);
            \Log::debug('Total lines in log file: ' . count($lines));

            // Regex to match Laravel log format: [YYYY-MM-DD HH:MM:SS] local.LEVEL: MESSAGE
            $logPattern = '/^\[(\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2})\](?:[a-zA-Z0-9\.]+\.)?([A-Z]+): (.*)/';

            foreach ($lines as $line) {
                if (preg_match($logPattern, $line, $matches)) {
                    $timestamp = $matches[1];
                    $level = $matches[2];
                    $message = (string) $matches[3];

                    if (!$filterLevel || strtoupper($filterLevel) === $level) {
                        $logs[] = [
                            'timestamp' => $timestamp,
                            'level' => $level,
                            'message' => $message,
                        ];
                    }
                } else {
                    // This line does not match the log pattern, so it's either a continuation of a previous log
                    // entry's message (e.g., a stack trace) or an unparseable line.
                    \Log::debug('No match for line. Appending to previous or skipping: ' . $line);
                    if (!empty($logs)) {
                        $logs[count($logs) - 1]['message'] .= "\n" . (string) $line;
                    }
                }
            }
        }
        
        // Reverse logs to show most recent first, and limit to last 500 entries for readability
        $logs = array_slice(array_reverse($logs), 0, 500);

        \Log::debug('Parsed log entries count: ' . count($logs));

        return view('dashboard.logs', [
            'logs' => $logs,
            'logType' => 'API Logs',
            'filterLevel' => $filterLevel,
        ]);
    }
}
