<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            // User Data
            'user_id' => $this->user_id,
            'email' => $this->user->email,

            // Profile Data (using database column names)
            'full_name' => $this->full_name,
            'company' => $this->company,
            'ICE' => $this->ICE,
            'phone_number' => $this->phone_number,
            'avatar_url' => $this->avatar_url,
            'locale' => $this->locale,
        ];
    }
}
