<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'status' => $this->status,
            'details' => $this->details,
            'user_id' => $this->user_id,
            'created_at' => $this->created_at->toDateTimeString(),
            'updated_at' => $this->updated_at->toDateTimeString(),
            'display_date' => in_array($this->status, ['in_progress', 'completed'])
                ? $this->updated_at->toDateTimeString()
                : $this->created_at->toDateTimeString(),
            // Eager load the service relationship for complete data
            'service' => new ServiceResource($this->whenLoaded('service')),
        ];
    }
}
