<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => optional($this->profile)->full_name ?? $this->name,
            'email' => $this->email,
            'company' => optional($this->profile)->company,
            'ICE' => optional($this->profile)->ICE,
            'phone_number' => optional($this->profile)->phone_number,
            'created_at' => $this->created_at,
        ];
    }
}
