<?php

namespace App\Listeners;

use App\Events\InvoiceCreated;
use App\Models\User;
use App\Services\NotificationService;
// Removed ShouldQueue and InteractsWithQueue for synchronous execution

class SendInvoiceCreatedNotification
{
    public function handle(InvoiceCreated $event)
    {
        \Log::info('SendInvoiceCreatedNotification listener started.', ['invoice_id' => $event->invoice->id]);

        $invoice = $event->invoice;
        $user = $invoice->user;

        if (!$user) {
            \Log::warning('SendInvoiceCreatedNotification: User not found for invoice.', ['invoice_id' => $invoice->id]);
            return;
        }

        $titleKey = 'notifications.invoice_created.title';
        $data = [
            'invoice_number' => $invoice->invoice_number,
        ];

        if ($invoice->project) {
            $bodyKey = 'notifications.invoice_created.body_with_project';
            $data['project_name'] = $invoice->project->name;
        } else {
            $bodyKey = 'notifications.invoice_created.body_without_project';
        }

        NotificationService::create(
            $user,
            $titleKey,
            $bodyKey,
            'user',
            $data
        );
        \Log::info('SendInvoiceCreatedNotification listener finished.', ['invoice_id' => $event->invoice->id]);
    }
}
