<?php

namespace App\Listeners;

use App\Events\InvoiceStatusUpdated;
use App\Models\User;
use App\Services\NotificationService;
// Removed ShouldQueue and InteractsWithQueue for synchronous execution

class SendInvoiceStatusNotification
{
    public function handle(InvoiceStatusUpdated $event)
    {
        \Log::info('SendInvoiceStatusNotification listener started.', ['invoice_id' => $event->invoice->id]);

        $invoice = $event->invoice;
        $user = $invoice->user;

        if (!$user) {
            \Log::warning('SendInvoiceStatusNotification: User not found for invoice.', ['invoice_id' => $invoice->id]);
            return;
        }

        $titleKey = 'notifications.invoice_status_updated.title';
        $bodyKey = 'notifications.invoice_status_updated.body';
        $data = [
            'invoice_number' => $invoice->invoice_number,
            'project_name' => $invoice->project->name ?? 'N/A', // Assuming invoice has a project relationship
            'status' => $invoice->status,
        ];

        NotificationService::create(
            $user,
            $titleKey,
            $bodyKey,
            'user',
            $data
        );
        \Log::info('SendInvoiceStatusNotification listener finished.', ['invoice_id' => $event->invoice->id]);
    }
}
