<?php

namespace App\Listeners;

use App\Events\ProjectStatusUpdated;
use App\Models\User;
use App\Services\NotificationService;
// Removed ShouldQueue and InteractsWithQueue for synchronous execution

class SendProjectStatusNotification
{
    public function handle(ProjectStatusUpdated $event)
    {
        \Log::info('SendProjectStatusNotification listener started.', ['project_id' => $event->project->id]);

        $project = $event->project;

        // If the project was just created, don't send a notification.
        if ($project->wasRecentlyCreated) {
            \Log::info('Project was recently created, skipping notification.', ['project_id' => $project->id]);
            return;
        }

        $user = $project->user;

        if (!$user) {
            \Log::warning('SendProjectStatusNotification: User not found for project.', ['project_id' => $project->id]);
            return;
        }

        $titleKey = 'notifications.project_status_updated.title';
        $bodyKey = 'notifications.project_status_updated.body';
        $data = [
            'project_name' => $project->name,
            'status' => $project->status,
        ];

        NotificationService::create(
            $user,
            $titleKey,
            $bodyKey,
            'user',
            $data
        );
        \Log::info('SendProjectStatusNotification listener finished.', ['project_id' => $event->project->id]);
    }
}
