<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EventTriggeredMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $subject;
    public $body;
    public $projectName;
    public $clientName;
    public $ownerName;
    public $ownerOffice;
    public $serviceName;
    public $clientId;
    public $clientICE;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subject, $body, $projectName = null, $clientName = null, $ownerName = null, $ownerOffice = null, $serviceName = null, $clientId = null, $clientICE = null)
    {
        $this->subject = $subject;
        $this->body = $body;
        $this->projectName = $projectName;
        $this->clientName = $clientName;
        $this->ownerName = $ownerName;
        $this->ownerOffice = $ownerOffice;
        $this->serviceName = $serviceName;
        $this->clientId = $clientId;
        $this->clientICE = $clientICE;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.event-triggered', [
            'projectName' => $this->projectName,
            'clientName' => $this->clientName,
            'ownerName' => $this->ownerName,
            'ownerOffice' => $this->ownerOffice,
            'serviceName' => $this->serviceName,
            'clientId' => $this->clientId,
            'clientICE' => $this->clientICE,
        ])->subject($this->subject);
    }
}
