<?php

// =============================================================================
// 1. ADVERTISEMENT MODEL (app/Models/Advertisement.php)
// =============================================================================

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Advertisement extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'image_url',
        'target_url',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the full URL for the advertisement image using Laravel's asset helper.
     * This uses the storage symlink: public/storage -> storage/app/public
     *
     * @param  string|null  $value
     * @return string|null
     */
    public function getImageUrlAttribute($value)
    {
        if (!$value) {
            return null;
        }

        // Uses Laravel's asset() helper to create URLs like:
        // Uses Laravel's asset() helper to create URLs like:
        // https://yourdomain.com/storage/advertisements/filename.png
        return asset('storage/' . $value);
    }
}