<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AuthCode extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'code',
        'expires_at',
        'is_used', // Added is_used to fillable
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'is_used' => 'boolean', // Cast to boolean
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
