<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'service_id',
        'name',
        'description',
        'status',
        'details',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'details' => 'json',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    /**
     * Set the details attribute.
     * This mutator automatically decodes the details if it's a JSON string,
     * removes the 'all_files' key, and then lets Laravel handle re-encoding.
     *
     * @param  mixed  $value
     * @return void
     */
    public function setDetailsAttribute($value)
    {
        $details = is_string($value) ? json_decode($value, true) : $value;

        if (is_array($details) && isset($details['all_files'])) {
            unset($details['all_files']);
        }

        // Encode the array back to a JSON string before setting the attribute.
        // This ensures the database receives a string, preventing the conversion error.
        $this->attributes['details'] = json_encode($details);
    }
}
