<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany; // Import for type hinting

class Service extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'description',
        'icon_name',
        'related_table_name',
        'screen_name',
        'schema',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'schema' => 'json',
    ];

    //======================================================================
    // RELATIONSHIPS
    //======================================================================

    /**
     * Get all the projects for the service.
     */
    public function projects(): HasMany
    {
        return $this->hasMany(Project::class);
    }
}