<?php

namespace App\Policies;

use App\Models\AuthCode;
use App\Models\User; // It's conventional to use the base User model for type-hinting here
use Illuminate\Auth\Access\HandlesAuthorization;

class AuthCodePolicy
{
    use HandlesAuthorization;

    /**
     * Grant all abilities to admins before other checks are run.
     * The incoming $user model will be an instance of Admin.
     */
    public function before($user, $ability)
    {
        // This check correctly identifies an Admin user via their token ability.
        if (method_exists($user, 'tokenCan') && $user->tokenCan('admin')) {
            return true;
        }
    }

    /**
     * Determine whether the user can view any models.
     * This is required by the `index` method.
     * The `before` method will already have granted access to admins.
     */
    public function viewAny(User $user): bool
    {
        // This will only be reached by non-admins, who should be denied.
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     * This is required by the `destroy` method.
     * The `before` method will already have granted access to admins.
     */
    public function delete(User $user, AuthCode $authCode): bool
    {
        // This will only be reached by non-admins, who should be denied.
        return false;
    }

    // NOTE: We don't need view(), create(), or update() because they are not
    // used by our AuthCodeController, so we don't need to define them.
}
