<?php

namespace App\Policies;

use App\Models\Invoice;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class InvoicePolicy
{
    use HandlesAuthorization;

    // Admins can do anything
    public function before($user, $ability)
    {
        if ($user->tokenCan('admin')) {
            return true;
        }
    }

    // A user can create an invoice if they are an admin.
    public function create(User $user): bool
    {
        return $user->tokenCan('admin');
    }

    // A user can view an invoice if they own it
    public function view(User $user, Invoice $invoice): bool
    {
        return $user->id === $invoice->user_id;
    }

    // A user can update an invoice if they own it
    public function update(User $user, Invoice $invoice): bool
    {
        return $user->id === $invoice->user_id;
    }

    // A user can delete an invoice if they own it
    public function delete(User $user, Invoice $invoice): bool
    {
        return $user->id === $invoice->user_id;
    }
}
