<?php

namespace App\Providers;

use Illuminate\Auth\Events\Registered;
use App\Events\UserDeleted;
use App\Listeners\RevokeUserTokens;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use App\Models\Notification; // Import the Notification model
use App\Observers\NotificationObserver; // Import the new Observer
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use App\Events\InvoiceCreated;
use App\Events\InvoiceStatusUpdated;
use App\Events\ProjectStatusUpdated;
use App\Listeners\SendInvoiceCreatedNotification;
use App\Listeners\SendInvoiceStatusNotification;
use App\Listeners\SendProjectStatusNotification;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        UserDeleted::class => [
            RevokeUserTokens::class,
        ],
        ProjectStatusUpdated::class => [
            SendProjectStatusNotification::class,
        ],
        InvoiceCreated::class => [
            SendInvoiceCreatedNotification::class,
        ],
        InvoiceStatusUpdated::class => [
            SendInvoiceStatusNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
    }
}
