<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('services', function (Blueprint $table) {
            $table->string('icon_name')->nullable()->after('description');
            $table->string('related_table_name')->nullable()->after('icon_name');
            $table->string('screen_name')->nullable()->after('related_table_name');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('services', function (Blueprint $table) {
            $table->dropColumn('icon_name');
            $table->dropColumn('related_table_name');
            $table->dropColumn('screen_name');
        });
    }
}