<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Service;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Service::create([
            'name' => 'E-mailing Campaign',
            'description' => 'Plan and execute email marketing campaigns.',
            'icon_name' => 'Mail',
            'related_table_name' => 'emailing_campaign_submissions',
            'screen_name' => 'EmailingCampaign',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Campaign Name", "required": true, "placeholder": "e.g., August Newsletter"}, {"id": 1756292032110, "key": "email_content_html", "type": "textarea", "label": "Email Content (HTML)", "required": true, "placeholder": "Paste your email HTML here..."}, {"id": 1756292032111, "key": "email_images", "type": "file", "label": "Email Images (Optional)", "accept": "image/*", "multiple": true, "required": false}, {"id": 1756292032112, "key": "contact_database", "type": "file", "label": "Contact Database (Optional)", "accept": ".csv,.xls,.xlsx", "required": false}, {"id": 1756292032113, "key": "test_email", "type": "text", "label": "Test Email Address", "required": false, "placeholder": "e.g., test@example.com"}, {"id": 1756292032114, "key": "target_audience", "type": "textarea", "label": "Target Audience Description", "required": false, "placeholder": "Describe the target audience for this campaign..."}]}',
            'created_at' => '2025-08-16 11:33:58',
        ]);

        Service::create([
            'name' => 'Website Creation',
            'description' => 'Build a new website from scratch.',
            'icon_name' => 'Building',
            'related_table_name' => 'website_creation_submissions',
            'screen_name' => 'WebsiteCreation',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Website / Business Name", "required": true, "placeholder": "e.g., My Awesome Business"}, {"id": 1756292032110, "key": "domain_name", "type": "text", "label": "Preferred Domain (Optional)", "required": false, "placeholder": "e.g., my-awesome-site.com"}, {"id": 1756292032111, "key": "example_sites", "type": "textarea", "label": "Example Sites / Inspiration", "required": false, "placeholder": "Enter up to 3 URLs, one per line..."}, {"id": 1756292032112, "key": "specifications_doc", "type": "file", "label": "Specifications Document (Cahier de charge)", "accept": ".pdf,.doc,.docx,.txt", "required": false}]}',
            'created_at' => '2025-08-16 11:33:58',
        ]);

        Service::create([
            'name' => 'Web Development',
            'description' => 'Custom website and web application development.',
            'icon_name' => 'Globe',
            'related_table_name' => 'website_creation_submissions',
            'screen_name' => 'WebDevelopment',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Project Name", "required": true}, {"id": 1756292032110, "key": "project_documents", "type": "file", "label": "Briefs, Plans, or Other Documents", "multiple": true, "required": false}, {"id": 1756292032111, "key": "design_mockups", "type": "file", "label": "Design Files / Mockups (if you have them)", "accept": "image/*", "multiple": true, "required": false}]}',
            'created_at' => '2025-08-14 19:29:25',
        ]);

        Service::create([
            'name' => 'Software',
            'description' => 'Custom software development services.',
            'icon_name' => 'Terminal',
            'related_table_name' => 'software_submissions',
            'screen_name' => 'Software',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Project / Company Name", "required": true}, {"id": 1756292032110, "key": "software_product", "type": "select", "label": "Select Software Product", "options": ["ATLAS GESTION 1 MAGASIN", "ATLAS GESTION MULTI MAGASIN", "ATLAS PARA", "ATLAS PHARMACIE", "ATLAS BIJOUX", "ATLAS HOTEL MANAGER", "ATLAS Toubib", "ATLAS VOYAGE MANAGER"], "required": true}, {"id": 1756292032111, "key": "company_logo", "type": "file", "label": "Company Logo (Optional)", "accept": "image/*", "required": false}, {"id": 1756292032112, "key": "contact_information", "type": "textarea", "label": "Contact Information (Address, Phone, etc.)", "required": true}, {"id": 1756739906959, "key": "date_1756739906959", "type": "date", "label": "New Date Field"}]}',
            'created_at' => '2025-08-16 11:33:58',
        ]);

        Service::create([
            'name' => 'SMS Marketing',
            'description' => 'Targeted SMS campaigns to engage your audience.',
            'icon_name' => 'MessageSquare',
            'related_table_name' => 'sms_marketing_submissions',
            'screen_name' => 'SmsMarketing',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Campaign Name", "required": true, "placeholder": "e.g., Summer Sale Promo"}, {"id": 1756292032110, "key": "message_content", "type": "textarea", "label": "Campaign Name", "required": true, "maxLength": 160, "placeholder": "Your marketing message (max 160 chars)..."}, {"id": 1756292032111, "key": "contact_database", "type": "file", "label": "Campaign Name", "accept": ".csv,.xls,.xlsx", "required": false}, {"id": 1756292032112, "key": "test_numbers", "type": "text", "label": "Campaign Name", "placeholder": "Enter numbers, comma separated"}, {"id": 1756292032113, "key": "target_city", "type": "text", "label": "Campaign Name", "required": false}, {"id": 1756292032114, "key": "target_category", "type": "text", "label": "Campaign Name", "required": false}, {"id": 1756292032115, "key": "target_social_class", "type": "text", "label": "Campaign Name", "required": false}]}',
            'created_at' => '2025-08-14 19:29:25',
        ]);

        Service::create([
            'name' => 'test',
            'description' => 'fileds preview',
            'icon_name' => 'Blocks',
            'related_table_name' => null,
            'screen_name' => null,
            'schema' => '{"fields": [{"id": 1756636720234, "key": "text_1756636720234", "type": "text", "label": "New Text Field"}, {"id": 1756636720890, "key": "textarea_1756636720890", "type": "textarea", "label": "New Textarea Field"}, {"id": 1756636721515, "key": "date_1756636721515", "type": "date", "label": "New Date Field"}, {"id": 1756636722170, "key": "file_1756636722170", "type": "file", "label": "New File Field"}, {"id": 1756637846572, "key": "file_1756637846572", "type": "file", "label": "New multi File Field", "multiple": true}, {"id": 1756636723242, "key": "select_1756636723242", "type": "select", "label": "New Select Field", "options": ["Option 1", "Option 2", "Option 3", "Option 4"]}, {"id": 1756636724236, "key": "multiselect_1756636724236", "type": "multiselect", "label": "New Multiselect Field", "options": ["Option 1", "Option 2", "Option 3", "Option 4"]}, {"id": 1756636725001, "key": "radio_1756636725001", "type": "radio", "label": "New Radio Field", "options": ["Option 1", "Option 2", "Option 3", "Option 4"]}, {"id": 1756636726146, "key": "checkbox_1756636726146", "type": "checkbox", "label": "New Checkbox Field", "options": ["Option 1", "Option 2"]}]}',
            'created_at' => '2025-08-31 10:40:36',
        ]);

        Service::create([
            'name' => 'Go Siyaha',
            'description' => 'Specialized administrative services for Go Siyaha.',
            'icon_name' => 'Briefcase',
            'related_table_name' => 'go_siyaha_submissions',
            'screen_name' => 'GoSiyaha',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Company Name", "required": true}, {"id": 1756292032110, "key": "company_statutes_doc", "type": "file", "label": "Statuts", "required": true}, {"id": 1756292032111, "key": "commercial_register_doc", "type": "file", "label": "Registre de commerce (modèle J)", "required": true}, {"id": 1756292032112, "key": "turnover_certificate_doc", "type": "file", "label": "Attestation du chiffre d’affaires 2024", "required": true}, {"id": 1756292032113, "key": "classification_doc", "type": "file", "label": "Document de classement", "required": true}, {"id": 1756292032114, "key": "classification_type", "type": "radio", "label": "Type of Classification / License", "options": ["Classement : Hôtel et Restaurant", "Agrément : le transporteur touristique", "Licence : pour les agents de voyages de type organisateur-distributeur de voyages"], "required": true}]}',
            'created_at' => '2025-08-14 19:29:25',
        ]);

        Service::create([
            'name' => 'Graphic Design',
            'description' => 'Branding, logos, and visual assets.',
            'icon_name' => 'PenTool',
            'related_table_name' => 'graphic_design_requests',
            'screen_name' => 'GraphicDesign',
            'schema' => '{"fields": [{"id": 1756292032109, "key": "project_name", "type": "text", "label": "Project Name", "required": true, "placeholder": "e.g., Summer Sale Campaign Graphics"}, {"id": 1756292032110, "key": "required_services", "type": "multiselect", "label": "Required Services", "options": ["Cartes de visite", "Affiches", "Brochures / dépliants", "Bannières RS", "Visuels RS", "Packaging et étiquettes produits", "Catalogue"], "required": true}, {"id": 1756292032111, "key": "other_requests", "type": "textarea", "label": "Other Requests / Details", "required": false, "placeholder": "Describe any other graphic design needs..."}]}',
            'created_at' => '2025-08-14 19:29:25',
        ]);
    }
}