<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\AuthCode; // Import the AuthCode model
use App\Models\Profile; // Import the Profile model
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserAndAuthCodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create a sample user
        $user = User::firstOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'Test User',
                'password' => Hash::make('password'), // You might not need a password if auth is only via code
                'email_verified_at' => now(),
                'remember_token' => Str::random(10),
            ]
        );

        // Create an authentication code for this user
        // Ensure the 'auth_codes' table exists and has 'user_id' and 'code' columns
        AuthCode::firstOrCreate(
            ['user_id' => $user->id],
            [
                'code' => '123456', // The authentication code for the mobile app
                'expires_at' => now()->addDays(7), // Code valid for 7 days
            ]
        );

        // Create a default profile for this user
        Profile::firstOrCreate(
            ['user_id' => $user->id],
            [
                'full_name' => 'Test User Profile',
                'avatar_url' => null,
            ]
        );

        $this->command->info('Test user and authentication code seeded successfully!');
    }
}
