@extends('layouts.dashboard')

@section('content')
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="p-6 bg-white border-b border-gray-200">
            <h2 class="text-2xl font-bold text-gray-800">{{ $logType }}</h2>

            <div class="mt-4 mb-4">
                <form action="/logs" method="GET" class="flex items-center space-x-2">
                    <label for="level" class="text-gray-700">Filter by Level:</label>
                    <select name="level" id="level" class="border rounded-md px-2 py-1">
                        <option value="">All</option>
                        <option value="DEBUG" {{ $filterLevel == 'DEBUG' ? 'selected' : '' }}>DEBUG</option>
                        <option value="INFO" {{ $filterLevel == 'INFO' ? 'selected' : '' }}>INFO</option>
                        <option value="NOTICE" {{ $filterLevel == 'NOTICE' ? 'selected' : '' }}>NOTICE</option>
                        <option value="WARNING" {{ $filterLevel == 'WARNING' ? 'selected' : '' }}>WARNING</option>
                        <option value="ERROR" {{ $filterLevel == 'ERROR' ? 'selected' : '' }}>ERROR</option>
                        <option value="CRITICAL" {{ $filterLevel == 'CRITICAL' ? 'selected' : '' }}>CRITICAL</option>
                        <option value="ALERT" {{ $filterLevel == 'ALERT' ? 'selected' : '' }}>ALERT</option>
                        <option value="EMERGENCY" {{ $filterLevel == 'EMERGENCY' ? 'selected' : '' }}>EMERGENCY</option>
                    </select>
                    <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-1 px-3 rounded">Filter</button>
                </form>
            </div>

            <div class="mt-4 bg-gray-800 text-white p-4 rounded-md h-96 overflow-y-scroll">
                @forelse ($logs as $log)
                    <div class="log-entry mb-2 pb-2 border-b border-gray-700 last:border-b-0">
                        <span class="text-gray-400">[{{ $log['timestamp'] }}]</span>
                        <span class="font-bold {{ 
                            $log['level'] == 'ERROR' || $log['level'] == 'CRITICAL' || $log['level'] == 'ALERT' || $log['level'] == 'EMERGENCY' ? 'text-red-400' : (
                            $log['level'] == 'WARNING' ? 'text-yellow-400' : (
                            $log['level'] == 'INFO' ? 'text-blue-400' : 'text-white'
                            ))
                        }}">[{{ $log['level'] }}]:</span>
                        <span class="text-gray-200">{{ is_array($log['message']) ? json_encode($log['message']) : $log['message'] }}</span>
                    </div>
                @empty
                    <p class="text-center text-gray-500">No log entries found for the selected filter.</p>
                @endforelse
            </div>
        </div>
    </div>
@endsection